#ifndef __GRAPH__
#define __GRAPH__

#include <iostream>
#include "Graph.h"
#include <algorithm>

/******************************************************************************************
ܣ캯

******************************************************************************************/
Graph::Graph()
{
}

/******************************************************************************************
ܣ붥

******************************************************************************************/
void Graph::InsertVertex(vid id, double la, double lo)
{
	vertex newVertex;
	newVertex.id = id;
	newVertex.la = la;
	newVertex.lo = lo;
	//newVertex.attr = attr;
	//newVertex.inflow = 0;
	sg.insert(pair<vid, vertex>(id, newVertex));
}

/******************************************************************************************
ܣ

******************************************************************************************/
void Graph::InsertEdge(int edgeID,vid id1, vid id2,  double inFlow, double outFlow,int direction)
{
	edge newEdge;
	newEdge.nodef = id1;
	newEdge.nodet = id2;
//	newEdge.inFlow = inFlow;
//	newEdge.outFlow = outFlow;
	newEdge.direction = direction;
	newEdge.edgeID = edgeID;
	eg.insert(pair<eid,edge>(edgeID,newEdge));

//	Direction :1= two-way road; 2=one way road from f->t; 3=one way road from t->f; 4= two direction can't go
	//update the vertices adj. list
	map<vid, vertex>::iterator mapit1 = sg.find(id1);
	map<vid, vertex>::iterator mapit2 = sg.find(id2);
	if(mapit1 != sg.end() && mapit2 != sg.end())
	{
		(*mapit1).second.e.push_back(newEdge);
		(*mapit2).second.e.push_back(newEdge);
/*		if(direction==1){
			(*mapit1).second.e.push_back(newEdge);
			(*mapit2).second.e.push_back(newEdge);
		}else if(direction==2){
			(*mapit1).second.e.push_back(newEdge);
		}else if(direction==3){
			(*mapit2).second.e.push_back(newEdge);
		}*/
	}
}

void Graph::Clear(){
	sg.clear();
	eg.clear();
}

void Graph::Visual(int size)
{
	int count=0;
	for(map<vid, vertex>::iterator it = sg.begin(); it != sg.end(); it++)
	{
		count++;
		if(count>size)
			break;

		printf("node %d (%f,%f)\n",(*it).first,(*it).second.la,(*it).second.lo);
	}
}

#endif